/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DHCPClientProcessEvent;
import com.cisco.pt.ipc.events.DHCPClientProcessEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.process.dhcp.DHCPClientProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHCPClientProcessEventRegistry
extends IPCEventRegistry {
    protected Set<DHCPClientProcessEventListener> globalListeners = new HashSet<DHCPClientProcessEventListener>();
    protected Map<String, Set<DHCPClientProcessEventListener>> specificObjectListeners = new HashMap<String, Set<DHCPClientProcessEventListener>>();
    private static Log logger = LogFactory.getLog(DHCPClientProcessEventRegistry.class);

    public DHCPClientProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "DhcpClientProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DHCPClientProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("dhcpSucceed")) {
            evt = new DHCPClientProcessEvent.DhcpSucceed(event);
        } else if (eventName.equalsIgnoreCase("dhcpConfigured")) {
            evt = new DHCPClientProcessEvent.DhcpConfigured(event);
        } else if (eventName.equalsIgnoreCase("dhcpFailed")) {
            evt = new DHCPClientProcessEvent.DhcpFailed(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (DHCPClientProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DHCPClientProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DHCPClientProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DHCPClientProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("dhcpSucceed");
                this.register("dhcpConfigured");
                this.register("dhcpFailed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DHCPClientProcessEventListener listener, DHCPClientProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DHCPClientProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DHCPClientProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "dhcpSucceed");
                this.register(uuid, "dhcpConfigured");
                this.register(uuid, "dhcpFailed");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DHCPClientProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("dhcpSucceed");
                this.deregister("dhcpConfigured");
                this.deregister("dhcpFailed");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DHCPClientProcessEventListener listener, DHCPClientProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DHCPClientProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "dhcpSucceed");
            this.deregister(uuid, "dhcpConfigured");
            this.deregister(uuid, "dhcpFailed");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DHCPClientProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DHCPClientProcessEventListener listener, DHCPClientProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DHCPClientProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DHCPClientProcessEventListener listener, DHCPClientProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

